// $Id: CDiskPathMenuItem.cpp,v 1.4 2007/02/08 21:07:54 paul Exp $

/*
 * All contents of this source code are copyright 2005 Exp Digital Uk.
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.
 * Certain sections of this code may come from other sources. They are credited where applicable.
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 */

#include "CDiskPathMenuItem.hpp"
#include <Host/CFileManager.hpp>
#include "CSubMenuMenuItem.hpp"

//	===========================================================================

using Exponent::GUI::Controls::CDiskPathMenuItem;
using Exponent::Host::CFileManager;
using Exponent::GUI::Controls::CSubMenuMenuItem;

//	===========================================================================
EXPONENT_CLASS_IMPLEMENTATION(CDiskPathMenuItem, CMenuItem);

//	===========================================================================
CDiskPathMenuItem::CDiskPathMenuItem(const CSystemString &path, const CString &text, const long identifier, const EMenuItemTypes type, const bool enabled) 
				 : CMenuItem(text, identifier, type, enabled)
				 , m_path(path)
{
	EXPONENT_CLASS_CONSTRUCTION(CDiskPathMenuItem);
}

//	===========================================================================
CDiskPathMenuItem::~CDiskPathMenuItem() 
{
	EXPONENT_CLASS_DESTRUCTION(CDiskPathMenuItem);
}

//	===========================================================================
void CDiskPathMenuItem::traverseDiskPath(const CSystemString &path, CMenu *menuToAddTo, const CString &extension)
{
	// Check we have a menu
	if (menuToAddTo == NULL)
	{
		return;
	}

	// Get the files to add
	TCountedPointerArray<CFileInformation> files;
	CFileManager::getFilesInDirectory(files, path);

	// Loop throught the array
	for (long i = 0; i < files.getArraySize(); i++)
	{
		// Get the file info
		CFileInformation *info = files.elementAtIndex(i);

		// Check its valid
		if (info)
		{
			// If its a directory
			if (info->isDirectory())
			{
				// Add a sub menu and recurse in to it
				CSubMenuMenuItem *subItem = new CSubMenuMenuItem(info->getFilename(), -1);
				CSystemString thePath = path;
				thePath.appendPath(info->getFilename());
				traverseDiskPath(thePath, subItem->getMutableSubMenu(), extension);
				menuToAddTo->addMenuItem(subItem);
			}
			else
			{
				// File, we can directly add
				CSystemString theName = info->getFilename();
				if (theName.hasExtension(extension))
				{
					theName.removeExtension();
					CSystemString theFilePath = path;
					theFilePath.appendPath(info->getFilename());
					menuToAddTo->addMenuItem(new CDiskPathMenuItem(theFilePath, theName, -1, CMenuItem::e_menuItemNormal)); 
				}
			}
		}
	}
	
	// We are done!
	return;
}